/* 
 *  AttachedDataTab.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient;

import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;

public class AttachedDataTab {

    private final Tab tab;
    private final StringDataTab stringData;
    private final KVPAttachedDataTab kvp;
    private final BinDataTab bin;
    private static final Logger LOG = Logger.getLogger(AttachedDataTab.class);

    public AttachedDataTab(InteractionExecutor interactionExe, InteractionDataGUI gui) {
        tab = new Tab();
        tab.setText("DATA");
        tab.setClosable(false);
        tab.setDisable(true);
        TabPane tabPane = new TabPane();
        stringData = new StringDataTab(interactionExe, gui);
        tabPane.getTabs().add(stringData.getTab());

        kvp = new KVPAttachedDataTab(LOG, interactionExe, gui);
        tabPane.getTabs().add(kvp.getTab());

        bin = new BinDataTab(interactionExe, gui);
        tabPane.getTabs().add(bin.getTab());
        
        tab.setContent(tabPane);
    }

    public Tab getTab() {
        return tab;
    }

    void update(InteractionDataI data) {
//        tab.setDisable(!data.canGetData());
    	tab.setDisable(false);
        stringData.update(data);
        kvp.update(data);
        bin.update(data);
    }
}
